<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// SİLME İŞLEMİ
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    $db->query("DELETE FROM blog_post_tags WHERE post_id = $id");
    $db->query("DELETE FROM blog_posts WHERE id = $id");
    header("Location: blogs.php");
    exit;
}

// YAZILARI ÇEK
$sql = "SELECT p.*, c.name as category_name, 
        (SELECT GROUP_CONCAT(t.name SEPARATOR ', ') FROM blog_post_tags pt JOIN blog_tags t ON pt.tag_id = t.id WHERE pt.post_id = p.id) as tags
        FROM blog_posts p 
        LEFT JOIN blog_categories c ON p.category_id = c.id 
        ORDER BY p.id DESC";
$yazilar = $db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Blog Yazıları</h6>
                <a href="blog-new.php" class="btn btn-primary px-4 py-2 radius-8 d-flex align-items-center gap-2">
                    <iconify-icon icon="solar:pen-new-square-linear" class="text-xl"></iconify-icon> Yeni Yazı Ekle
                </a>
            </div>

            <div class="card h-100 p-0 radius-12">
                <div class="card-body p-24">
                    <div class="table-responsive">
                        <table class="table bordered-table sm-table mb-0">
                            <thead>
                                <tr>
                                    <th>Görsel</th>
                                    <th>Başlık / Kategori</th>
                                    <th>Etiketler</th>
                                    <th>Durum</th>
                                    <th>Tarih</th>
                                    <th>İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($yazilar as $y): ?>
                                <tr>
                                    <td>
                                        <div class="w-64-px h-64-px radius-8 overflow-hidden bg-light d-flex align-items-center justify-content-center">
                                            <?php if(!empty($y['image'])): ?>
                                                <img src="assets/images/uploads/<?php echo $y['image']; ?>" class="w-100 h-100 object-fit-cover">
                                            <?php else: ?>
                                                <iconify-icon icon="solar:gallery-wide-linear" class="text-2xl text-secondary-light"></iconify-icon>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <h6 class="text-md fw-bold mb-1"><?php echo htmlspecialchars($y['title']); ?></h6>
                                        <span class="badge bg-primary-50 text-primary-600 border border-primary-100 px-2 py-1 radius-4 text-xs">
                                            <?php echo !empty($y['category_name']) ? htmlspecialchars($y['category_name']) : 'Genel'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if(!empty($y['tags'])): ?>
                                            <?php $etiketler = explode(', ', $y['tags']); foreach($etiketler as $etiket): ?>
                                                <span class="badge bg-base text-secondary-light border border-gray-200 px-2 py-1 radius-4 text-xs me-1 mb-1">#<?php echo htmlspecialchars($etiket); ?></span>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <span class="text-xs text-secondary-light">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($y['status'] == 'published'): ?>
                                            <span class="badge bg-success-focus text-success-main px-2 py-1 radius-4">Yayında</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary-light text-secondary-600 px-2 py-1 radius-4">Taslak</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-sm text-secondary-light">
                                        <?php echo date("d.m.Y", strtotime($y['created_at'])); ?>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <a href="blog-edit.php?id=<?php echo $y['id']; ?>" class="w-32-px h-32-px bg-success-focus text-success-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                                <iconify-icon icon="lucide:edit-2"></iconify-icon>
                                            </a>

                                            <a href="?del=<?php echo $y['id']; ?>" onclick="return confirm('Bu yazıyı silmek istediğinize emin misiniz?')" class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                                <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>