<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$mesaj = "";
$mesaj_tur = "";

// 1. Müşteri Ekleme (Manuel)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name     = trim($_POST['name']);
    $company  = trim($_POST['company_name']);
    $email    = trim($_POST['email']);
    $phone    = trim($_POST['phone']);
    $address  = trim($_POST['address']);

    if(!empty($name)) {
        $sql = "INSERT INTO customers (name, company_name, email, phone, address) VALUES (:name, :comp, :email, :phone, :addr)";
        $stmt = $db->prepare($sql);
        $insert = $stmt->execute([
            'name' => $name, 'comp' => $company, 'email' => $email, 'phone' => $phone, 'addr' => $address
        ]);
        if($insert) { $mesaj = "Müşteri eklendi."; $mesaj_tur = "success"; }
    }
}

// 2. Müşteri Silme
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    $db->query("DELETE FROM customers WHERE id = $id");
    // Sildikten sonra tekrar AYNI sayfaya yönlendir
    header("Location: clients.php"); 
    exit;
}

// Listeyi Çek
$musteriler = $db->query("SELECT * FROM customers ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Müşteri Yönetimi (CRM)</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="index.php">Dashboard</a></li>
                    <li>-</li>
                    <li class="fw-medium">Müşteriler</li>
                </ul>
            </div>

            <div class="row gy-4">
                <div class="col-lg-4">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Hızlı Müşteri Ekle</h6>
                        </div>
                        <div class="card-body p-24">
                            
                            <?php if($mesaj != ""): ?>
                                <div class="alert alert-<?php echo $mesaj_tur; ?> d-flex align-items-center gap-2 border-0 radius-8 px-16 py-12 mb-24 shadow-sm">
                                    <iconify-icon icon="lucide:check-circle" class="text-xl"></iconify-icon>
                                    <p class="mb-0 text-sm"><?php echo $mesaj; ?></p>
                                </div>
                            <?php endif; ?>

                            <form action="" method="POST">
                                <div class="mb-3"><label class="form-label text-sm fw-semibold">Ad Soyad</label><input type="text" name="name" class="form-control radius-8" required></div>
                                <div class="mb-3"><label class="form-label text-sm fw-semibold">Firma Adı</label><input type="text" name="company_name" class="form-control radius-8"></div>
                                <div class="mb-3"><label class="form-label text-sm fw-semibold">Telefon</label><input type="text" name="phone" class="form-control radius-8"></div>
                                <div class="mb-3"><label class="form-label text-sm fw-semibold">Email</label><input type="email" name="email" class="form-control radius-8"></div>
                                <div class="mb-3"><label class="form-label text-sm fw-semibold">Adres</label><textarea name="address" class="form-control radius-8" rows="2"></textarea></div>
                                <button type="submit" class="btn btn-primary w-100 radius-8">Kaydet</button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Müşteri Listesi</h6>
                        </div>
                        <div class="card-body p-24">
                            <div class="table-responsive">
                                <table class="table bordered-table sm-table mb-0">
                                    <thead><tr><th>İsim / Firma</th><th>İletişim</th><th>İşlem</th></tr></thead>
                                    <tbody>
                                        <?php foreach($musteriler as $m): ?>
                                        <tr>
                                            <td>
                                                <h6 class="text-md mb-0 fw-bold"><?php echo htmlspecialchars($m['name']); ?></h6>
                                                <small class="text-secondary"><?php echo htmlspecialchars($m['company_name']); ?></small>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-column gap-1">
                                                    <?php if($m['phone']): ?><span class="text-sm text-secondary-light"><iconify-icon icon="solar:phone-outline" class="me-1"></iconify-icon> <?php echo $m['phone']; ?></span><?php endif; ?>
                                                    <?php if($m['email']): ?><span class="text-sm text-secondary-light"><iconify-icon icon="solar:letter-outline" class="me-1"></iconify-icon> <?php echo $m['email']; ?></span><?php endif; ?>
                                                </div>
                                            </td>
                                            <td>
                                                <a href="?del=<?php echo $m['id']; ?>" onclick="return confirm('Bu müşteriyi silmek istediğinize emin misiniz?')" class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                                    <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>