<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$mesaj = "";
$mesaj_tur = "";

// --- İKON LİSTESİ ---
$icons = [
    'solar:info-circle-outline', 'solar:question-circle-outline', 'solar:card-outline', 
    'solar:wallet-outline', 'solar:box-minimalistic-outline', 'solar:delivery-outline',
    'solar:restart-circle-outline', 'solar:settings-outline', 'solar:user-circle-outline',
    'solar:shield-check-outline', 'solar:phone-outline', 'solar:letter-outline',
    'solar:cart-large-minimalistic-outline', 'solar:tag-outline', 'solar:star-outline'
];

// 1. SIRALAMA GÜNCELLEME (TOPLU)
if (isset($_POST['update_order']) && isset($_POST['sira'])) {
    foreach ($_POST['sira'] as $id => $sira) {
        $id = intval($id);
        $sira = intval($sira);
        $db->query("UPDATE faq_categories SET sort_order = $sira WHERE id = $id");
    }
    $mesaj = "Kategori sıralaması güncellendi.";
    $mesaj_tur = "success";
}

// 2. KATEGORİ EKLEME
if (isset($_POST['add_category'])) {
    $title = trim($_POST['title']);
    $icon = trim($_POST['icon']);
    $sort_order = intval($_POST['sort_order']);
    
    if (!empty($title) && !empty($icon)) {
        $stmt = $db->prepare("INSERT INTO faq_categories (title, icon, sort_order) VALUES (?, ?, ?)");
        $stmt->execute([$title, $icon, $sort_order]);
        $mesaj = "Kategori başarıyla eklendi.";
        $mesaj_tur = "success";
    } else {
        $mesaj = "Lütfen başlık ve ikon seçiniz.";
        $mesaj_tur = "danger";
    }
}

// 3. KATEGORİ SİLME
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    // Bu kategoriye ait soruları varsayılan kategoriye (1) taşıyalım ki silinmesinler
    $db->query("UPDATE faqs SET category = '1' WHERE category = '$id'");
    $db->query("DELETE FROM faq_categories WHERE id = $id");
    header("Location: faq-categories.php");
    exit;
}

// Listeyi Çek (Sıraya Göre: sort_order ASC)
$cats = $db->query("SELECT * FROM faq_categories ORDER BY sort_order ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<style>
    /* İkon Seçici Tasarımı */
    .icon-radio { display: none; }
    .icon-box {
        cursor: pointer; border: 1px solid #eee; border-radius: 8px;
        display: flex; justify-content: center; align-items: center;
        height: 50px; transition: all 0.2s; font-size: 24px; color: #666;
    }
    .icon-radio:checked + .icon-box {
        background-color: var(--primary-100); border-color: var(--primary-600); color: var(--primary-600);
    }
    .icon-box:hover { background-color: #f9f9f9; }
</style>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">S.S.S. Kategorileri</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="faq.php">S.S.S.</a></li>
                    <li>-</li>
                    <li class="fw-medium">Kategoriler</li>
                </ul>
            </div>

            <?php if($mesaj != ""): ?>
                <div class="alert alert-<?php echo $mesaj_tur; ?> d-flex align-items-center gap-2 border-0 radius-8 px-16 py-12 mb-24 shadow-sm">
                    <iconify-icon icon="lucide:check-circle" class="text-xl"></iconify-icon>
                    <p class="mb-0 text-sm"><?php echo $mesaj; ?></p>
                </div>
            <?php endif; ?>

            <div class="row gy-4">
                
                <div class="col-lg-5">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Yeni Kategori Ekle</h6>
                        </div>
                        <div class="card-body p-24">
                            
                            <form action="" method="POST">
                                <input type="hidden" name="add_category" value="1">
                                
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Sıra No</label>
                                    <input type="number" name="sort_order" class="form-control radius-8" value="0">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Kategori Başlığı</label>
                                    <input type="text" name="title" class="form-control radius-8" placeholder="Örn: Ödeme İşlemleri" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">İkon Seçin</label>
                                    <div class="row g-2">
                                        <?php foreach($icons as $ic): ?>
                                        <div class="col-3">
                                            <label class="w-100">
                                                <input type="radio" name="icon" value="<?php echo $ic; ?>" class="icon-radio" required>
                                                <div class="icon-box">
                                                    <iconify-icon icon="<?php echo $ic; ?>"></iconify-icon>
                                                </div>
                                            </label>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary w-100 radius-8">Kaydet</button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-7">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Mevcut Kategoriler</h6>
                        </div>
                        <div class="card-body p-24">
                            
                            <form action="" method="POST">
                                <div class="table-responsive">
                                    <table class="table bordered-table sm-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 80px;">Sıra</th>
                                                <th>İkon</th>
                                                <th>Başlık</th>
                                                <th>İşlem</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($cats as $c): ?>
                                            <tr>
                                                <td>
                                                    <input type="number" name="sira[<?php echo $c['id']; ?>]" value="<?php echo $c['sort_order']; ?>" 
                                                           class="form-control text-center px-1" 
                                                           style="height: 35px;">
                                                </td>

                                                <td><iconify-icon icon="<?php echo $c['icon']; ?>" class="text-2xl text-primary-600"></iconify-icon></td>
                                                <td class="fw-bold"><?php echo htmlspecialchars($c['title']); ?></td>
                                                
                                                <td>
                                                    <?php if($c['id'] != 1): // Genel kategori silinemesin ?>
                                                    <a href="?del=<?php echo $c['id']; ?>" onclick="return confirm('Silmek istiyor musunuz?')" class="btn btn-danger-focus text-danger-main px-2 py-1 radius-4">
                                                        <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                                    </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="d-flex justify-content-end mt-24">
                                    <button type="submit" name="update_order" class="btn btn-success px-24 py-12 radius-8 d-flex align-items-center gap-2">
                                        <iconify-icon icon="solar:refresh-circle-outline" class="text-xl"></iconify-icon>
                                        Sıralamayı Güncelle
                                    </button>
                                </div>
                            </form>
                            </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>