<?php
session_start();
// Veritabanı gerekmiyor ama oturum kontrolü için system/db.php çağırabiliriz veya manuel kontrol ederiz.
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// 1. AYARLAR
$upload_dir = 'assets/images/uploads/'; // Dosyaların tutulacağı yer
if (!file_exists($upload_dir)) { mkdir($upload_dir, 0777, true); } // Klasör yoksa oluştur

$mesaj = "";
$mesaj_tur = "";

// 2. DOSYA YÜKLEME (UPLOAD)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["fileUpload"])) {
    $target_file = $upload_dir . basename($_FILES["fileUpload"]["name"]);
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    // Aynı isimde dosya var mı? (Varsa ismin sonuna zaman ekle)
    if (file_exists($target_file)) {
        $filename = pathinfo($_FILES["fileUpload"]["name"], PATHINFO_FILENAME);
        $target_file = $upload_dir . $filename . "_" . time() . "." . $imageFileType;
    }

    // Yükleme İşlemi
    if (move_uploaded_file($_FILES["fileUpload"]["tmp_name"], $target_file)) {
        $mesaj = "Dosya başarıyla yüklendi: " . basename($target_file);
        $mesaj_tur = "success";
    } else {
        $mesaj = "Dosya yüklenirken bir hata oluştu.";
        $mesaj_tur = "danger";
    }
}

// 3. DOSYA SİLME
if (isset($_GET['del'])) {
    $file_to_delete = $upload_dir . basename($_GET['del']);
    if (file_exists($file_to_delete)) {
        unlink($file_to_delete);
        header("Location: files.php?msg=deleted"); // URL temizlensin diye yönlendir
        exit;
    }
}

// Silme sonrası mesajı yakala
if(isset($_GET['msg']) && $_GET['msg'] == 'deleted'){
    $mesaj = "Dosya kalıcı olarak silindi.";
    $mesaj_tur = "success";
}

// 4. DOSYALARI LİSTELE
// Nokta (.) ve çift nokta (..) hariç tüm dosyaları al
$files = array_diff(scandir($upload_dir), array('.', '..'));
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Dosya Yöneticisi</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="index.php">Dashboard</a></li>
                    <li>-</li>
                    <li class="fw-medium">Dosyalar</li>
                </ul>
            </div>

            <?php if($mesaj != ""): ?>
                <div class="alert alert-<?php echo $mesaj_tur; ?> d-flex align-items-center gap-2 border-0 radius-8 px-16 py-12 mb-24 shadow-sm">
                    <?php if($mesaj_tur == 'success'): ?>
                        <iconify-icon icon="lucide:check-circle" class="text-xl"></iconify-icon>
                    <?php else: ?>
                        <iconify-icon icon="lucide:alert-triangle" class="text-xl"></iconify-icon>
                    <?php endif; ?>
                    <p class="mb-0 text-sm"><?php echo $mesaj; ?></p>
                </div>
            <?php endif; ?>

            <div class="card radius-12 mb-24 border-0 shadow-sm">
                <div class="card-body p-24">
                    <form action="" method="POST" enctype="multipart/form-data" class="d-flex align-items-end gap-3 flex-wrap">
                        <div class="flex-grow-1">
                            <label class="form-label fw-semibold text-primary-light text-sm mb-8">Yeni Dosya Yükle</label>
                            <input type="file" name="fileUpload" class="form-control radius-8" required>
                        </div>
                        <button type="submit" class="btn btn-primary px-24 py-10 radius-8 d-flex align-items-center gap-2">
                            <iconify-icon icon="solar:upload-outline" class="text-xl"></iconify-icon> Yükle
                        </button>
                    </form>
                </div>
            </div>

            <div class="row row-cols-xxxl-5 row-cols-xl-4 row-cols-lg-3 row-cols-sm-2 row-cols-1 gy-4">
                
                <?php if(count($files) > 0): ?>
                    <?php foreach($files as $file): ?>
                        <?php 
                            $file_path = $upload_dir . $file;
                            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                            $is_image = in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp']);
                            
                            // Tam URL (Kopyalamak için)
                            // Sunucu yapına göre 'https://site.com/' kısmını dinamik de alabiliriz ama şimdilik path yetebilir.
                            // Kullanıcı kopyaladığında "/assets/..." şeklinde alacak.
                            $full_link = $upload_dir . $file; 
                        ?>
                        <div class="col">
                            <div class="card h-100 radius-12 border shadow-none position-relative overflow-hidden group-hover">
                                
                                <div class="card-header border-bottom-0 p-0 position-relative">
                                    <div class="ratio ratio-4x3 bg-base d-flex justify-content-center align-items-center">
                                        <?php if($is_image): ?>
                                            <img src="<?php echo $file_path; ?>" alt="file" class="object-fit-contain w-100 h-100">
                                        <?php else: ?>
                                            <iconify-icon icon="solar:file-text-outline" class="text-6xl text-secondary-light"></iconify-icon>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="card-body p-16">
                                    <h6 class="text-sm fw-semibold mb-1 text-truncate" title="<?php echo $file; ?>">
                                        <?php echo $file; ?>
                                    </h6>
                                    <p class="text-xs text-secondary-light mb-12">
                                        <?php echo strtoupper($ext); ?> Dosyası - <?php echo round(filesize($file_path) / 1024, 2); ?> KB
                                    </p>
                                    
                                    <div class="d-flex gap-2">
                                        <button onclick="copyLink('<?php echo $full_link; ?>')" class="btn btn-outline-primary w-100 py-1 text-xs radius-4 d-flex justify-content-center align-items-center gap-1">
                                            <iconify-icon icon="solar:copy-outline"></iconify-icon> Link
                                        </button>
                                        
                                        <a href="?del=<?php echo $file; ?>" onclick="return confirm('Bu dosyayı kalıcı olarak silmek istiyor musunuz?')" class="btn btn-danger-focus text-danger-main py-1 px-2 radius-4 text-xs">
                                            <iconify-icon icon="mingcute:delete-2-line" class="text-lg"></iconify-icon>
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12">
                        <div class="alert alert-secondary text-center">Henüz hiç dosya yüklenmemiş.</div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>

    <script>
    function copyLink(link) {
        // Tam URL oluşturmak için site adresini başına ekleyelim
        var fullPath = window.location.origin + window.location.pathname.replace('files.php', '') + link;
        
        navigator.clipboard.writeText(fullPath).then(function() {
            alert("Link kopyalandı:\n" + fullPath);
        }, function(err) {
            console.error('Kopyalama hatası: ', err);
        });
    }
    </script>
</body>
</html>