<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Faturaları Çek
$sql = "SELECT * FROM invoices ORDER BY id DESC";
$faturalar = $db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Fatura Listesi</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="index.php" class="hover-text-primary">Dashboard</a></li>
                    <li>-</li>
                    <li class="fw-medium">Faturalar</li>
                </ul>
            </div>

            <div class="card h-100 p-0 radius-12">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Kesilen Faturalar</h6>
                    <a href="invoice-new.php" class="btn btn-primary text-sm btn-sm px-12 py-12 radius-8 d-flex align-items-center gap-2">
                        <iconify-icon icon="ic:baseline-plus" class="icon text-xl line-height-1"></iconify-icon>
                        Fatura Kes
                    </a>
                </div>
                
                <div class="card-body p-24">
                    <div class="table-responsive scroll-sm">
                        <table class="table bordered-table sm-table mb-0">
                            <thead>
                                <tr>
                                    <th scope="col">Fatura No</th>
                                    <th scope="col">Müşteri</th>
                                    <th scope="col">Tutar</th>
                                    <th scope="col">Tarih</th>
                                    <th scope="col" class="text-center">Durum</th>
                                    <th scope="col" class="text-center">İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($faturalar) > 0): ?>
                                    <?php foreach($faturalar as $fat): ?>
                                    <tr>
                                        <td>
                                            <span class="text-primary-600 fw-bold">#<?php echo $fat['invoice_no']; ?></span>
                                        </td>
                                        <td>
                                            <h6 class="text-md mb-0 fw-medium"><?php echo htmlspecialchars($fat['customer_name']); ?></h6>
                                        </td>
                                        <td>
                                            <span class="text-md fw-bold"><?php echo number_format($fat['total_amount'], 2); ?> ₺</span>
                                        </td>
                                        <td><?php echo date("d.m.Y", strtotime($fat['issue_date'])); ?></td>
                                        <td class="text-center">
                                            <?php 
                                                $durum_renk = 'secondary';
                                                $durum_text = 'Bilinmiyor';
                                                
                                                if($fat['status'] == 'paid') { $durum_renk = 'success'; $durum_text = 'Ödendi'; }
                                                elseif($fat['status'] == 'pending') { $durum_renk = 'warning'; $durum_text = 'Bekliyor'; }
                                                elseif($fat['status'] == 'unpaid') { $durum_renk = 'danger'; $durum_text = 'Ödenmedi'; }
                                                elseif($fat['status'] == 'cancelled') { $durum_renk = 'dark'; $durum_text = 'İptal'; }
                                            ?>
                                            <span class="bg-<?php echo $durum_renk; ?>-focus text-<?php echo $durum_renk; ?>-main px-24 py-4 rounded-pill fw-medium text-sm">
                                                <?php echo $durum_text; ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <div class="d-flex align-items-center justify-content-center gap-2">
                                                <a href="invoice-print.php?id=<?php echo $fat['id']; ?>" class="w-32-px h-32-px bg-primary-focus text-primary-main rounded-circle d-inline-flex align-items-center justify-content-center" title="Görüntüle">
                                                    <iconify-icon icon="solar:eye-outline"></iconify-icon>
                                                </a>
                                                <a href="invoice-delete.php?id=<?php echo $fat['id']; ?>" onclick="return confirm('Bu faturayı silmek istediğinize emin misiniz?')" class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                                    <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="6" class="text-center py-4">Henüz hiç fatura kesilmemiş.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>