<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// ID Kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: invoice-list.php");
    exit;
}

$id = intval($_GET['id']);

// 1. Fatura Bilgilerini Çek
$fatura = $db->query("SELECT * FROM invoices WHERE id = $id")->fetch(PDO::FETCH_ASSOC);

if (!$fatura) { die("Fatura bulunamadı."); }

// 2. Fatura Kalemlerini (Ürünleri) Çek
$kalemler = $db->query("SELECT * FROM invoice_items WHERE invoice_id = $id")->fetchAll(PDO::FETCH_ASSOC);

// 3. Bizim Şirket Bilgilerini (Ayarlardan) Çek
$ayar = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fatura #<?php echo $fatura['invoice_no']; ?></title>
    <link rel="stylesheet" href="assets/css/remixicon.css">
    <link rel="stylesheet" href="assets/css/lib/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>

    <style>
        /* YAZDIRMA AYARLARI (Sadece kağıda basılacak kısım) */
        @media print {
            body * {
                visibility: hidden; /* Her şeyi gizle */
            }
            #printableArea, #printableArea * {
                visibility: visible; /* Sadece fatura alanını göster */
            }
            #printableArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }
            .no-print {
                display: none !important; /* Butonları gizle */
            }
            .card {
                border: none !important; /* Kenarlıkları kaldır */
                box-shadow: none !important;
            }
        }
    </style>
</head>

<body class="bg-light">

    <div class="container py-5">
        
        <div class="d-flex justify-content-between align-items-center mb-4 no-print">
            <a href="invoice-list.php" class="btn btn-secondary px-3 py-2 radius-8 d-flex align-items-center gap-2">
                <iconify-icon icon="solar:arrow-left-outline"></iconify-icon> Listeye Dön
            </a>
            <button onclick="window.print()" class="btn btn-primary px-4 py-2 radius-8 d-flex align-items-center gap-2">
                <iconify-icon icon="solar:printer-outline" class="text-xl"></iconify-icon> Yazdır / PDF İndir
            </button>
        </div>

        <div class="card radius-12 border-0 shadow-sm" id="printableArea">
            <div class="card-body p-48">
                
                <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 border-bottom pb-4 mb-4">
                    <div>
                        <img src="assets/images/logo.png" alt="Logo" class="mb-2" style="max-height: 50px;">
                        <h5 class="fw-bold mb-0 text-primary-600"><?php echo htmlspecialchars($ayar['site_title']); ?></h5>
                    </div>
                    <div class="text-end">
                        <h4 class="fw-bold mb-1">FATURA</h4>
                        <p class="mb-0 text-secondary-light">No: <span class="text-primary-600 fw-bold">#<?php echo $fatura['invoice_no']; ?></span></p>
                        <p class="mb-0 text-secondary-light">Tarih: <?php echo date("d.m.Y", strtotime($fatura['issue_date'])); ?></p>
                        
                        <div class="mt-2">
                            <?php if($fatura['status'] == 'paid'): ?>
                                <span class="badge bg-success-focus text-success-main border border-success-main px-3 py-1">ÖDENDİ</span>
                            <?php elseif($fatura['status'] == 'pending'): ?>
                                <span class="badge bg-warning-focus text-warning-main border border-warning-main px-3 py-1">BEKLİYOR</span>
                            <?php else: ?>
                                <span class="badge bg-danger-focus text-danger-main border border-danger-main px-3 py-1">ÖDENMEDİ</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-sm-6">
                        <h6 class="text-secondary-light text-uppercase fw-semibold text-sm mb-2">GÖNDEREN:</h6>
                        <h6 class="mb-1 fw-bold"><?php echo htmlspecialchars($ayar['site_title']); ?></h6>
                        <p class="mb-1 text-secondary-light text-sm"><?php echo nl2br(htmlspecialchars($ayar['contact_address'])); ?></p>
                        <p class="mb-0 text-secondary-light text-sm">Tel: <?php echo $ayar['contact_phone']; ?></p>
                        <p class="mb-0 text-secondary-light text-sm">Email: <?php echo $ayar['contact_email']; ?></p>
                    </div>

                    <div class="col-sm-6 text-sm-end mt-4 mt-sm-0">
                        <h6 class="text-secondary-light text-uppercase fw-semibold text-sm mb-2">SAYIN (ALICI):</h6>
                        
                        <?php if(!empty($fatura['company_name'])): ?>
                            <h6 class="mb-1 fw-bold"><?php echo htmlspecialchars($fatura['company_name']); ?></h6>
                            <p class="mb-1 fw-medium text-dark">Yetkili: <?php echo htmlspecialchars($fatura['customer_name']); ?></p>
                        <?php else: ?>
                            <h6 class="mb-1 fw-bold"><?php echo htmlspecialchars($fatura['customer_name']); ?></h6>
                        <?php endif; ?>

                        <p class="mb-1 text-secondary-light text-sm"><?php echo nl2br(htmlspecialchars($fatura['customer_address'])); ?></p>
                        
                        <?php if(!empty($fatura['customer_phone'])): ?>
                            <p class="mb-0 text-secondary-light text-sm">Cep: <?php echo $fatura['customer_phone']; ?></p>
                        <?php endif; ?>
                        
                        <?php if(!empty($fatura['customer_landline'])): ?>
                            <p class="mb-0 text-secondary-light text-sm">Tel: <?php echo $fatura['customer_landline']; ?></p>
                        <?php endif; ?>
                        
                        <?php if(!empty($fatura['customer_email'])): ?>
                            <p class="mb-0 text-secondary-light text-sm"><?php echo $fatura['customer_email']; ?></p>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="table-responsive mb-4">
                    <table class="table table-striped bordered-table">
                        <thead class="bg-base">
                            <tr>
                                <th scope="col" class="py-3">Açıklama / Hizmet</th>
                                <th scope="col" class="py-3 text-center">Miktar</th>
                                <th scope="col" class="py-3 text-end">Birim Fiyat</th>
                                <th scope="col" class="py-3 text-end">Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($kalemler as $kalem): ?>
                            <tr>
                                <td class="fw-medium"><?php echo htmlspecialchars($kalem['description']); ?></td>
                                <td class="text-center"><?php echo $kalem['quantity']; ?></td>
                                <td class="text-end"><?php echo number_format($kalem['unit_price'], 2); ?> ₺</td>
                                <td class="text-end fw-bold"><?php echo number_format($kalem['total_price'], 2); ?> ₺</td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-end">
                    <div class="col-lg-4 col-sm-6">
                        <table class="table table-borderless">
                            <tbody>
                                <tr class="border-bottom">
                                    <td class="fw-medium text-secondary-light">Ara Toplam:</td>
                                    <td class="text-end fw-bold"><?php echo number_format($fatura['total_amount'], 2); ?> ₺</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-dark fs-5">GENEL TOPLAM:</td>
                                    <td class="text-end fw-bold text-primary-600 fs-5"><?php echo number_format($fatura['total_amount'], 2); ?> ₺</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="mt-5 border-top pt-4">
                    <h6 class="text-sm fw-bold">Notlar & Şartlar:</h6>
                    <p class="text-sm text-secondary-light mb-0">Ödemenin, fatura tarihinden itibaren 7 gün içinde yapılması rica olunur. İşbirliğiniz için teşekkür ederiz.</p>
                </div>

                <div class="mt-5 text-center">
                    <p class="text-sm text-secondary-light">Bu belge bilişim sistemleri tarafından üretilmiştir.</p>
                </div>

            </div>
        </div>
    </div>

</body>
</html>