<?php
require_once 'system/db.php';
// Ayarları çek
$ayar = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($ayar['maintenance_title']); ?></title>
    <link rel="stylesheet" href="assets/css/lib/bootstrap.min.css">
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <style>
        body { background-color: #f4f6f8; height: 100vh; display: flex; align-items: center; justify-content: center; text-align: center; }
        .maintenance-card { background: white; padding: 50px; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); max-width: 600px; width: 90%; }
        .icon-box { width: 80px; height: 80px; background: #eef2ff; color: #4f46e5; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 20px; }
    </style>
</head>
<body>

    <div class="maintenance-card">
        <div class="icon-box">
            <iconify-icon icon="solar:settings-bold-duotone" style="font-size: 40px;"></iconify-icon>
        </div>
        <h2 class="fw-bold text-dark mb-3"><?php echo htmlspecialchars($ayar['maintenance_title']); ?></h2>
        <p class="text-secondary mb-0" style="font-size: 18px; line-height: 1.6;">
            <?php echo nl2br(htmlspecialchars($ayar['maintenance_text'])); ?>
        </p>
    </div>

</body>
</html>