<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$mesaj = "";
$mesaj_tur = "";

// 1. SIRALAMA GÜNCELLEME (Toplu İşlem)
if (isset($_POST['update_order'])) {
    $siralama = $_POST['sira']; // Formdan gelen dizi: [id => sira_no]

    foreach ($siralama as $id => $sira) {
        $id = intval($id);
        $sira = intval($sira);
        $db->query("UPDATE testimonials SET sort_order = $sira WHERE id = $id");
    }
    
    $mesaj = "Sıralama başarıyla güncellendi.";
    $mesaj_tur = "success";
}

// 2. YENİ YORUM EKLEME
if (isset($_POST['add_new'])) {
    $name = trim($_POST['name']);
    $company = trim($_POST['company']);
    $comment = trim($_POST['comment']);
    $rating = intval($_POST['rating']);
    $sort_order = intval($_POST['sort_order']); // Elle girilen sıra no

    if (!empty($name) && !empty($comment)) {
        $sql = "INSERT INTO testimonials (name, company, comment, rating, sort_order) VALUES (:name, :comp, :comm, :rate, :sort)";
        $stmt = $db->prepare($sql);
        $insert = $stmt->execute(['name' => $name, 'comp' => $company, 'comm' => $comment, 'rate' => $rating, 'sort' => $sort_order]);

        if ($insert) {
            $mesaj = "Yorum başarıyla eklendi.";
            $mesaj_tur = "success";
        }
    } else {
        $mesaj = "İsim ve Yorum alanları zorunludur.";
        $mesaj_tur = "danger";
    }
}

// 3. SİLME İŞLEMİ
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    $db->query("DELETE FROM testimonials WHERE id = $id");
    header("Location: testimonials.php");
    exit;
}

// LİSTEYİ ÇEK (Sıraya Göre: sort_order ASC)
$yorumlar = $db->query("SELECT * FROM testimonials ORDER BY sort_order ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Müşteri Yorumları</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="index.php">Dashboard</a></li>
                    <li>-</li>
                    <li class="fw-medium">Yorumlar</li>
                </ul>
            </div>

            <?php if($mesaj != ""): ?>
                <div class="alert alert-<?php echo $mesaj_tur; ?> d-flex align-items-center gap-2 border-0 radius-8 px-16 py-12 mb-24 shadow-sm">
                    <iconify-icon icon="lucide:check-circle" class="text-xl"></iconify-icon>
                    <p class="mb-0 text-sm"><?php echo $mesaj; ?></p>
                </div>
            <?php endif; ?>

            <div class="row gy-4">
                
                <div class="col-lg-4">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Yeni Yorum Ekle</h6>
                        </div>
                        <div class="card-body p-24">
                            <form action="" method="POST">
                                <input type="hidden" name="add_new" value="1">
                                
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Sıra No</label>
                                    <input type="number" name="sort_order" class="form-control radius-8" value="0">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Müşteri Adı Soyadı</label>
                                    <input type="text" name="name" class="form-control radius-8" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Firma / Ünvan</label>
                                    <input type="text" name="company" class="form-control radius-8">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Puan</label>
                                    <select name="rating" class="form-control radius-8">
                                        <option value="5">⭐⭐⭐⭐⭐ (5)</option>
                                        <option value="4">⭐⭐⭐⭐ (4)</option>
                                        <option value="3">⭐⭐⭐ (3)</option>
                                        <option value="2">⭐⭐ (2)</option>
                                        <option value="1">⭐ (1)</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Yorum</label>
                                    <textarea name="comment" class="form-control radius-8" rows="4" required></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary w-100 radius-8">Yorumu Kaydet</button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Yorum Listesi</h6>
                        </div>
                        <div class="card-body p-24">
                            
                            <form action="" method="POST">
                                <div class="table-responsive">
                                    <table class="table bordered-table sm-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 80px;">Sıra</th>
                                                <th>Müşteri / Yorum</th>
                                                <th class="text-center">Puan</th>
                                                <th>İşlem</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($yorumlar as $y): ?>
                                            <tr>
                                                <td>
                                                    <input type="number" name="sira[<?php echo $y['id']; ?>]" value="<?php echo $y['sort_order']; ?>" 
                                                           class="form-control text-center px-1" 
                                                           style="height: 35px;">
                                                </td>
                                                
                                                <td>
                                                    <h6 class="text-md mb-0 fw-bold"><?php echo htmlspecialchars($y['name']); ?></h6>
                                                    <small class="text-secondary d-block mb-1"><?php echo htmlspecialchars($y['company']); ?></small>
                                                    <p class="text-sm text-secondary-light mb-0 text-truncate" style="max-width: 300px;">
                                                        "<?php echo htmlspecialchars($y['comment']); ?>"
                                                    </p>
                                                </td>
                                                
                                                <td class="text-center">
                                                    <span class="text-warning-main text-lg">
                                                        <?php echo str_repeat("★", $y['rating']); ?>
                                                    </span>
                                                </td>
                                                
                                                <td>
                                                    <a href="?del=<?php echo $y['id']; ?>" onclick="return confirm('Bu yorumu silmek istiyor musunuz?')" class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                                        <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <?php if(count($yorumlar) > 0): ?>
                                <div class="d-flex justify-content-end mt-24">
                                    <button type="submit" name="update_order" class="btn btn-success px-24 py-12 radius-8 d-flex align-items-center gap-2">
                                        <iconify-icon icon="solar:refresh-circle-outline" class="text-xl"></iconify-icon>
                                        Sıralamayı Güncelle
                                    </button>
                                </div>
                                <?php else: ?>
                                    <p class="text-center text-secondary py-4">Henüz hiç yorum eklenmemiş.</p>
                                <?php endif; ?>
                                
                            </form>
                            </div>
                    </div>
                </div>

            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>